%% Import energy data NEDC urban bus and transform to power

Ciclo=xlsread('Ciclo');
t=Ciclo(:,1);
v=Ciclo(:,2);
E=Ciclo(:,3);

P=zeros(length(t),1);
for i=2:length(t)
    P(i)=E(i)*1000*3600/(t(i)-t(i-1)); % P en watios
end

figure
plot(t,P/1000)
grid on
title('Cycle power')
xlabel('Time (s)')
ylabel('Power (kW)')
clearvars i NEDC